<?php
if (!defined('ABSPATH')) {
    exit;
}

class WC_Product_Donation extends WC_Product {
    
    public function __construct($product) {
        $this->product_type = 'donation';
        $this->supports[] = 'ajax_add_to_cart';
        parent::__construct($product);
    }
    
    public function get_type() {
        return 'donation';
    }
    
    public function is_purchasable() {
        return true;
    }
    
    public function is_sold_individually() {
        return true;
    }
    
    public function is_virtual() {
        return true;
    }
    
    public function needs_shipping() {
        return false;
    }
    
    public function add_to_cart_url() {
        return get_permalink($this->get_id());
    }
    
    public function add_to_cart_text() {
        return __('Donate Now', 'wc-custom-donation');
    }
}